<?php
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/config.php';

use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

function webpush_client(): WebPush {
  $auth = [
    'VAPID' => [
      'subject' => VAPID_SUBJECT,
      'publicKey' => VAPID_PUBLIC_KEY,
      'privateKey' => VAPID_PRIVATE_KEY,
    ],
  ];
  return new WebPush($auth);
}

function send_push_to_subscribers(mysqli $conn, int $org_id, array $payload): array {
  $webPush = webpush_client();

  $stmt = $conn->prepare("SELECT id, endpoint, p256dh, auth FROM subscribers WHERE org_id = ?");
  $stmt->bind_param("i", $org_id);
  $stmt->execute();
  $res = $stmt->get_result();
  $rows = $res->fetch_all(MYSQLI_ASSOC);
  $stmt->close();

  foreach ($rows as $s) {
    $sub = Subscription::create([
      'endpoint' => $s['endpoint'],
      'keys' => [
        'p256dh' => $s['p256dh'],
        'auth'   => $s['auth'],
      ],
    ]);

    $webPush->queueNotification($sub, json_encode($payload, JSON_UNESCAPED_SLASHES));
  }

  $ok = 0; $fail = 0; $expired_ids = [];

  foreach ($webPush->flush() as $report) {
    if ($report->isSuccess()) {
      $ok++;
    } else {
      $fail++;
      // If subscription is expired/invalid, remove it
      $endpoint = $report->getRequest()->getUri()->__toString();
      // best-effort: delete by endpoint
      $stmt = $conn->prepare("DELETE FROM subscribers WHERE org_id = ? AND endpoint = ?");
      $stmt->bind_param("is", $org_id, $endpoint);
      $stmt->execute();
      $stmt->close();
    }
  }

  return ['sent' => $ok, 'failed' => $fail];
}
