<?php
require_once __DIR__ . '/../main/server/config.php';

function h($s) {
  return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Event Notis — Notify your people, fast.</title>
  <meta name="description" content="Create events and notify interested people via web push." />
  <meta name="theme-color" content="#0b1020" />

  <link rel="manifest" href="<?= APP_BASE ?>manifest.webmanifest">
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/base.css" />
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/landing.css" />

  <script>
    window.APP_BASE = <?= json_encode(APP_BASE) ?>;
  </script>
</head>

<body>
  <div class="wrap">
    <header class="topbar">
      <div class="brand">
        <div class="logo" aria-hidden="true"></div>
        <div>
          <div class="brand-title">Event Notis</div>
          <div class="brand-sub">Organizer notifications, done right</div>
        </div>
      </div>

      <nav class="nav">
        <a class="btn ghost" href="#how">How it works</a>
        <a class="btn ghost" href="#faq">FAQ</a>
        <a class="btn" href="<?= APP_BASE ?>admin/login.php">Admin sign in</a>
        <a class="btn primary" href="<?= APP_BASE ?>admin/register.php">Create admin</a>
      </nav>
    </header>

    <main class="hero">
      <section class="card">
        <h1 class="h1">Notify the right people.<br/>Fill your event faster.</h1>
        <p class="sub">
          Event Notis uses web push notifications for event alerts.
          <span class="muted">On iPhone, push requires installing the site to the Home Screen (PWA).</span>
        </p>

        <div class="pillrow">
          <div class="pill">🔔 Web Push</div>
          <div class="pill">🏫 Organizations</div>
          <div class="pill">🧾 Share codes</div>
          <div class="pill">📅 Event reminders</div>
        </div>

        <div class="ctaRow">
          <a class="btn primary" href="<?= APP_BASE ?>admin/register.php">Create organization admin</a>
          <a class="btn" href="<?= APP_BASE ?>admin/login.php">Sign in</a>
          <span class="smallNote">Free to start • No app required</span>
        </div>

        <div class="grid3" aria-label="Highlights">
          <div class="kpi">
            <h3>Share code onboarding</h3>
            <p>Admins create an organization and share one code/link with members.</p>
            <div class="tag">Simple setup</div>
          </div>
          <div class="kpi">
            <h3>Subscriber opt-in</h3>
            <p>Members open the link and enable notifications on their device.</p>
            <div class="tag">One-time opt-in</div>
          </div>
          <div class="kpi">
            <h3>Event alerts</h3>
            <p>Admins create events and everyone subscribed gets a push notification.</p>
            <div class="tag">Instant notify</div>
          </div>
        </div>
      </section>

      <aside class="rightCol">
        <div class="card card-soft">
          <h2 class="miniTitle">For organizers</h2>

          <div class="feature">
            <div class="dot"></div>
            <div>
              <b>Create an org</b>
              <p>Generate a share code and subscriber link.</p>
            </div>
          </div>

          <div class="feature">
            <div class="dot"></div>
            <div>
              <b>Create events</b>
              <p>Post an event and send a push instantly.</p>
            </div>
          </div>

          <div class="feature">
            <div class="dot"></div>
            <div>
              <b>Works on iOS (installed)</b>
              <p>We guide iPhone users to Add to Home Screen for push.</p>
            </div>
          </div>
        </div>

        <div class="card card-soft">
          <h2 class="miniTitle">Try subscribing</h2>
          <p class="sub sub-tight">
            Subscribers use an org’s share link like:
          </p>
          <div class="codeRow" style="margin-top:10px; position:relative;">
            <code><?= h((isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}" . APP_BASE . "s.php?code=ABC12345") ?></code>
          </div>
          <p class="muted tiny" style="position:relative; margin-top:10px;">
            (Admins get the real code on the dashboard.)
          </p>
        </div>
      </aside>
    </main>

    <section id="how" class="section">
      <div class="card">
        <h2 class="sectionTitle">How it works</h2>
        <p class="sub sub-tight">
          Admins only. Subscribers never need accounts.
        </p>

        <div class="steps">
          <div class="step">
            <div class="num">1</div>
            <div><b>Create admin + org</b><span>Admin registers and creates an organization.</span></div>
          </div>
          <div class="step">
            <div class="num">2</div>
            <div><b>Share the code</b><span>Send the org link/code to members who want notifications.</span></div>
          </div>
          <div class="step">
            <div class="num">3</div>
            <div><b>Create events</b><span>Admins create events; subscribers receive push notifications.</span></div>
          </div>
        </div>
      </div>

      <div id="faq" class="card faq">
        <h2 class="sectionTitle">FAQ</h2>

        <details>
          <summary>Do subscribers need to sign in?</summary>
          <p>No. They just open the organization link and enable notifications.</p>
        </details>

        <details>
          <summary>Does push work on iPhone?</summary>
          <p>
            Yes, if the site is added to the Home Screen (installed PWA). We’ll guide iOS users on the subscribe page.
          </p>
        </details>

        <details>
          <summary>Where do admins manage everything?</summary>
          <p>
            Admin dashboard: <code><?= APP_BASE ?>admin/dashboard.php</code>
          </p>
        </details>
      </div>
    </section>

    <footer>
      <div>© <span id="y"></span> Event Notis</div>
      <div class="footerLinks">
        <a class="linkish" href="<?= APP_BASE ?>terms">Terms</a>
        <span>·</span>
        <a class="linkish" href="<?= APP_BASE ?>privacy">Privacy</a>
        <span>·</span>
        <a class="linkish" href="<?= APP_BASE ?>contact">Contact</a>
      </div>
    </footer>
  </div>

  <script src="<?= APP_BASE ?>assets/js/landing.js" defer></script>
</body>
</html>
