(() => {
  const copy = async (text) => {
    try {
      await navigator.clipboard.writeText(text);
      return true;
    } catch {
      return false;
    }
  };

  const codeEl = document.getElementById("shareCode");
  const linkEl = document.getElementById("shareLink");
  const copyCode = document.getElementById("copyCode");
  const copyLink = document.getElementById("copyLink");

  if (copyCode && codeEl) {
    copyCode.addEventListener("click", async () => {
      const ok = await copy(codeEl.textContent.trim());
      copyCode.textContent = ok ? "Copied" : "Copy failed";
      setTimeout(() => (copyCode.textContent = "Copy"), 900);
    });
  }

  if (copyLink && linkEl) {
    copyLink.addEventListener("click", async () => {
      const ok = await copy(linkEl.textContent.trim());
      copyLink.textContent = ok ? "Copied" : "Copy failed";
      setTimeout(() => (copyLink.textContent = "Copy"), 900);
    });
  }
})();
