<?php
require_once __DIR__ . '/../server/db.php';
require_once __DIR__ . '/../server/auth.php';
require_once __DIR__ . '/../server/config.php';
require_once __DIR__ . '/../server/push.php';
require_admin();

$admin_id = admin_id();
$org_id = (int)($_POST['org_id'] ?? 0);

$stmt = $conn->prepare("SELECT id, name FROM organizations WHERE id = ? AND admin_id = ? LIMIT 1");
$stmt->bind_param("ii", $org_id, $admin_id);
$stmt->execute();
$org = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$org) { http_response_code(403); exit("Unauthorized org."); }

$title = trim($_POST['title'] ?? '');
$starts_at = trim($_POST['starts_at'] ?? '');
$location = trim($_POST['location'] ?? '');
$signup_url = trim($_POST['signup_url'] ?? '');
$description = trim($_POST['description'] ?? '');

if ($title === '') { http_response_code(400); exit("Missing title."); }

$starts_sql = null;
if ($starts_at !== '') {
  // datetime-local comes as "YYYY-MM-DDTHH:MM"
  $starts_sql = str_replace('T', ' ', $starts_at) . ':00';
}

$stmt = $conn->prepare("
  INSERT INTO events (org_id, title, starts_at, location, description, signup_url)
  VALUES (?, ?, ?, ?, ?, ?)
");
$stmt->bind_param("isssss", $org_id, $title, $starts_sql, $location, $description, $signup_url);
$stmt->execute();
$event_id = (int)$stmt->insert_id;
$stmt->close();

// Push payload
$body = $title;
if ($starts_sql) $body .= " • " . $starts_sql;
if ($location) $body .= " • " . $location;

$url = $signup_url ?: (APP_BASE . "event.php?id=" . $event_id); // event.php can be added later

$payload = [
  'title' => $org['name'],
  'body'  => $body,
  'url'   => $url
];

send_push_to_subscribers($conn, $org_id, $payload);

header("Location: " . APP_BASE . "admin/dashboard.php");
exit;
