<?php
require_once __DIR__ . '/../server/db.php';
require_once __DIR__ . '/../server/config.php';

if (session_status() !== PHP_SESSION_ACTIVE) session_start();

$email = trim($_POST['email'] ?? '');
$pass  = (string)($_POST['password'] ?? '');

$stmt = $conn->prepare("SELECT id, pass_hash FROM admins WHERE email = ? LIMIT 1");
$stmt->bind_param("s", $email);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$row || !password_verify($pass, $row['pass_hash'])) {
  http_response_code(401);
  exit("Invalid login.");
}

$_SESSION['admin_id'] = (int)$row['id'];
header("Location: " . APP_BASE . "admin/dashboard.php");
exit;
