<?php
require_once __DIR__ . '/../server/config.php';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Register Admin — Event Notis</title>
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/base.css" />
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/admin.css" />
</head>
<body>
  <div class="wrap narrow">
    <a class="back" href="<?= APP_BASE ?>index.html">← Back</a>
    <div class="card">
      <h1>Create admin account</h1>
      <p class="muted">Admins manage an organization and send event notifications.</p>

      <form class="form" method="post" action="<?= APP_BASE ?>api/admin_register.php">
        <label>Email</label>
        <input name="email" type="email" required autocomplete="email" />
        <label>Password</label>
        <input name="password" type="password" required minlength="8" autocomplete="new-password" />
        <button class="btn primary" type="submit">Create account</button>
      </form>

      <div class="row">
        <span class="muted">Already have an account?</span>
        <a class="linkish" href="<?= APP_BASE ?>admin/login.php">Sign in</a>
      </div>
    </div>
  </div>
</body>
</html>
