<?php
require_once __DIR__ . '/../server/db.php';
require_once __DIR__ . '/../server/auth.php';
require_once __DIR__ . '/../server/config.php';

require_admin();

$admin_id = admin_id();

// Load org (1 org per admin to start)
$stmt = $conn->prepare("SELECT * FROM organizations WHERE admin_id = ? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("i", $admin_id);
$stmt->execute();
$org = $stmt->get_result()->fetch_assoc();
$stmt->close();

$org_id = (int)($org['id'] ?? 0);
$events = [];

if ($org_id > 0) {
  $stmt = $conn->prepare("SELECT * FROM events WHERE org_id = ? ORDER BY id DESC LIMIT 20");
  $stmt->bind_param("i", $org_id);
  $stmt->execute();
  $events = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
  $stmt->close();
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Dashboard — Event Notis</title>
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/base.css" />
  <link rel="stylesheet" href="<?= APP_BASE ?>assets/css/admin.css" />
  <script>
    window.APP_BASE = <?= json_encode(APP_BASE) ?>;
    window.ORG = <?= json_encode($org ?: null) ?>;
  </script>
</head>
<body>
  <div class="wrap">
    <header class="top">
      <div>
        <h1>Organizer Dashboard</h1>
        <div class="muted">Manage your organization and send event notifications.</div>
      </div>
      <a class="btn" href="<?= APP_BASE ?>admin/logout.php">Logout</a>
    </header>

    <?php if (!$org): ?>
      <div class="card">
        <h2>Create your organization</h2>
        <p class="muted">This generates a share code you can give to members.</p>
        <form class="form" method="post" action="<?= APP_BASE ?>api/org_create.php">
          <label>Organization name</label>
          <input name="name" required maxlength="190" />
          <button class="btn primary" type="submit">Create organization</button>
        </form>
      </div>
    <?php else: ?>
      <div class="grid">
        <div class="card">
          <h2><?= h($org['name']) ?></h2>
          <p class="muted">Share code for subscribers:</p>
          <div class="codeRow">
            <code id="shareCode"><?= h($org['share_code']) ?></code>
            <button class="btn" type="button" id="copyCode">Copy</button>
          </div>

          <p class="muted" style="margin-top:12px;">Subscriber link:</p>
          <div class="codeRow">
            <code id="shareLink"><?= h((isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}" . APP_BASE . "s.php?code=" . $org['share_code']) ?></code>
            <button class="btn" type="button" id="copyLink">Copy</button>
          </div>
        </div>

        <div class="card">
          <h2>Create event</h2>
          <form class="form" method="post" action="<?= APP_BASE ?>api/event_create.php">
            <input type="hidden" name="org_id" value="<?= (int)$org['id'] ?>" />
            <label>Title</label>
            <input name="title" required maxlength="190" />
            <label>Starts at (optional)</label>
            <input name="starts_at" type="datetime-local" />
            <label>Location (optional)</label>
            <input name="location" maxlength="190" />
            <label>Signup URL (optional)</label>
            <input name="signup_url" type="url" />
            <label>Description (optional)</label>
            <textarea name="description" rows="4"></textarea>

            <button class="btn primary" type="submit">Create + send push</button>
            <div class="muted tiny">Creates the event and immediately sends a notification to all subscribers.</div>
          </form>
        </div>
      </div>

      <div class="card">
        <h2>Recent events</h2>
        <?php if (count($events) === 0): ?>
          <div class="muted">No events yet.</div>
        <?php else: ?>
          <div class="table">
            <div class="thead">
              <div>Title</div><div>Start</div><div>Location</div>
            </div>
            <?php foreach ($events as $e): ?>
              <div class="trow">
                <div><?= h($e['title']) ?></div>
                <div class="muted"><?= h($e['starts_at'] ?? '') ?></div>
                <div class="muted"><?= h($e['location'] ?? '') ?></div>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

  <script src="<?= APP_BASE ?>assets/js/admin.js" defer></script>
</body>
</html>
